#!/usr/bin/env python3
from random import randint
import sys

sys.setrecursionlimit(200000)

MAX_DIST = 3

n, m = map(int, input().split())
g = [[] for _ in range(n)]
for _ in range(m):
    u, v = map(int, input().split())
    u -= 1
    v -= 1
    g[u].append(v)
    g[v].append(u)

s = randint(0, n - 1)
visited = [False] * n
chosen = [False] * n

ans = []

d = 3

# (vertex, next neighbour index)
stack = [(s, 0)]

while len(stack) > 0:
    u, i = stack.pop()
    if i == 0:
        visited[u] = True
        if d == MAX_DIST:
            ans.append(u)
            chosen[u] = True
            d = 0
    while i <= len(g[u]):
        if i == len(g[u]):
            if not chosen[u]:
                ans.append(u)
                d = 0
            d += 1
            break
        v = g[u][i]
        if visited[v]:
            i += 1
            continue
        d += 1
        stack.append((u, i + 1))
        stack.append((v, 0))
        break

print(*map(lambda x: x + 1, ans))
