#!/usr/bin/env python3
# Can be accepted using Cpython, but PyPy doesn't handle deep recursion properly.
# @EXPECTED_RESULTS@: RUN_TIME_ERROR, TIME_LIMIT_EXCEEDED, ACCEPTED
from random import randint
import sys

sys.setrecursionlimit(200000)

MAX_DIST = 3

n, m = map(int, input().split())
g = [[] for _ in range(n)]
for _ in range(m):
    u, v = map(int, input().split())
    u -= 1
    v -= 1
    g[u].append(v)
    g[v].append(u)

s = randint(0, n - 1)
visited = [False] * n
chosen = [False] * n

ans = []

# Do a DFS from s, also passing the distance to the previous chosen vertex.
# Returns the distance to the last chosen vertex.
def dfs(u, d):
    assert not visited[u]
    visited[u] = True
    if d == MAX_DIST:
        ans.append(u)
        assert not chosen[u]
        chosen[u] = True
        d = 0

    for v in g[u]:
        if visited[v]:
            continue
        d = dfs(v, d + 1)

    if not chosen[u]:
        ans.append(u)
        d = 0
    return d + 1


dfs(s, 3)

print(*map(lambda x: x + 1, ans))
