#include <iostream>
#include <vector>

using namespace std;

vector<vector<int>> adj;
int n, m;
vector<int> path;

int dfs(int root, bool top, int low) {
    if(top)
        path[root] = low++;
    else
        path[root] = -1;
    for(int nb : adj[root]) {
        if(path[nb])
            continue;
        low = dfs(nb, !top, low);
    }
    if(!top)
        path[root] = low++;
    return low;
}

int main() {
    cin >> n >> m;
    adj = vector<vector<int>>(n);
    path = vector<int>(n, 0);
    for(int i = 0; i < m; i++) {
        int a, b; cin >> a >> b;
        a -= 1;
        b -= 1;
        adj[a].push_back(b);
        adj[b].push_back(a);
    }
    dfs(0, true, 1);
    for(int i = 0; i < n; i++)
        cout << path[i] << " ";
    cout << endl;
}
