import java.awt.*;
import java.io.*;
import java.util.*;

public class Maarten {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new Maarten().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        int n = Integer.parseInt(reader.readLine());

        int[] ts = new int[n];
        int k = 0;
        for (String x : reader.readLine().split(" ")) {
            ts[k++] = Integer.parseInt(x);
        }

        int[] ss = new int[n];
        k = 0;
        for (String x : reader.readLine().split(" ")) {
            ss[k++] = Integer.parseInt(x);
        }

        Point[] problems = new Point[n];
        for (int i = 0; i < n; i++) {
            problems[i] = new Point(ss[i], ts[i]);
        }
        Arrays.sort(problems, Comparator.comparingInt(p -> p.x));

        int total = 0, ans = 0;
        for (Point problem : problems) {
            if (problem.x == -1) continue;
            total += problem.y;
            ans = Math.max(ans, (total + problem.x - 1) / problem.x);
        }
        System.out.println(ans);
    }
}
