#include "validation.h"

// True when b is a subsequence of a.
bool is_subsequence(const std::string& a, const std::string& b) {
	auto it = a.begin();
	for(auto c : b) {
		while(it != a.end() and c != *it) ++it;
		if(it == a.end()) return false;
		assert(c == *it);
		++it;
	}
	return true;
}

int main(int argc, char** argv) {
	std::ifstream in(argv[1]);

	int n, testcase_seed, fixed_seed;
	in >> n >> testcase_seed;

	// Generate the team input.
	std::random_device dev;
	auto random_seed = dev();

	auto seed = testcase_seed ^ random_seed;

	if(in >> fixed_seed) {
		seed = fixed_seed;
	}

	std::cerr << "Seed: " << seed << std::endl;

	int ans_len = n / 2;

	// Generate the team input.
	std::string s1, s2;
	{
		Generator g(seed);
		g.read_integer("n", n, n);
		g.newline();
		s1 = g.read_string("s1", n, n, "ACTG");
		g.newline();
		s2 = g.read_string("s2", n, n, "ACTG");
		g.newline();
	}

	// Validate the team output.
	OutputValidator v(argc, argv);
	std::string ans = v.read_string("ans", 1, n, "ACTG");
	v.newline();

	v.check(ans.size() >= ans_len, "Answer is not long enough: ", ans.size(), " < ", ans_len);

	v.check(is_subsequence(s1, ans), "Answer is not a subsequence of first input string.");
	v.check(is_subsequence(s2, ans), "Answer is not a subsequence of second input string.");
	std::cerr << "Output has length " << ans.size() << std::endl;
}
